/*
	The Controller handles mushroom nursery maintenance.
*/
#ifndef Controller_h
#define Controller_h

#include "Arduino.h"
#include "Internet.h"
#include "ArduinoJson.h"

class Controller
{
  public:
    Controller(int test);
    void init();
    void loop(Internet internet);
    void applyConfig(JsonDocument config);
    void manageExhaustFan();
    void manageDevices();
    void manageHumidifer();
    void manageDayLight();
    void manageUvLight();
    void readSensor();

  private:
  	bool 	_configReady;
  	bool	_exhaustFanOn;
	bool 	_exhaustFanOverrideEnable;
	int 	_exhaustFanOnCycle;
	int 	_exhaustFanOffCycle;

	bool 	_humidiferOverrideEnable;
	bool 	_atomizerOn;
	bool 	_intakeFanOn;
	int 	_humiditySetValue;
	int 	_humidityDiffValue;

	bool 	_dayLightOn;
	bool 	_dayLightOverrideEnable;
	int 	_dayLightStartHour;
	int 	_dayLightStartMin;
	int 	_dayLightEndHour;
	int 	_dayLightEndMin;

	bool 	_uvLightOn;
	bool 	_uvLightOverrideEnable;
	int 	_uvLightStartHour;
	int 	_uvLightStartMin;
	int 	_uvLightEndHour;
	int 	_uvLightEndMin;

	//Sensor Values
	float _tempF;
	float _humidity;

	//LiveStatus
	bool _STATUS_ATOMIZER_ON;
	bool _STATUS_INTAKE_ON;
	bool _STATUS_EXHAUST_ON;
	bool _STATUS_DAYLIGHT_ON;
	bool _STATUS_UVLIGHT_ON;

	//Exhaust timer
	bool _cycleON;
	unsigned long int _cycleStartTime;

	//Intake timer
	unsigned long int _ATOMIZER_START_TIME;

};

#endif